package com.example.myapplication

import android.os.Bundle
import android.util.Log
import android.view.View
import android.widget.ImageButton
import android.widget.NumberPicker
import android.widget.TableRow
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.app.AppCompatActivity
import kotlinx.android.synthetic.main.table.*
import kotlinx.android.synthetic.main.ticktacktoo.*

class MainActivity: AppCompatActivity(), View.OnClickListener, NumberPicker.OnValueChangeListener {
    lateinit var squares:Squares
    var next:Boolean = true
    var isFinal = true
    lateinit var imagebutton:Array<Array<ImageButton>>
    lateinit var row:Array<TableRow>

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.ticktacktoo)

        imagebutton = arrayOf(
            arrayOf(imageButton11,imageButton12,imageButton13,imageButton14,imageButton15,imageButton16,imageButton17),
            arrayOf(imageButton21,imageButton22,imageButton23,imageButton24,imageButton25,imageButton26,imageButton27),
            arrayOf(imageButton31,imageButton32,imageButton33,imageButton34,imageButton35,imageButton36,imageButton37),
            arrayOf(imageButton41,imageButton42,imageButton43,imageButton44,imageButton45,imageButton46,imageButton47),
            arrayOf(imageButton51,imageButton52,imageButton53,imageButton54,imageButton55,imageButton56,imageButton57),
            arrayOf(imageButton61,imageButton62,imageButton63,imageButton64,imageButton65,imageButton66,imageButton67),
            arrayOf(imageButton71,imageButton72,imageButton73,imageButton74,imageButton75,imageButton76,imageButton77)
        )
        row = arrayOf(tablerow1,tablerow2,tablerow3,tablerow4,tablerow5,tablerow6,tablerow7)

        for(idx1 in imagebutton.indices){
            for(idx2 in imagebutton[idx1].indices){
                imagebutton[idx1][idx2].setOnClickListener(this)
                var array = arrayOf(idx1,idx2)
                imagebutton[idx1][idx2].setTag(array)
            }
        }
        button.setOnClickListener(this)
        numberPicker.minValue = Const.BAN_MINI
        numberPicker.maxValue = Const.BAN_MAX
        numberPicker.value = Const.BAN_MINI
        numberPicker.setOnValueChangedListener(this)

        numberPicker2.minValue = Const.BAN_MINI
        numberPicker2.maxValue = Const.BAN_MAX
        numberPicker2.value = Const.BAN_MINI

        numberPicker2.setOnValueChangedListener(this)
        squares = Squares(imagebutton)
        init()

        val list9: List<Int>
        list9 = listOf(1, 2, 3)
        //list.add(3)           //エラー
        //list.set(0,9)         //エラー
        list9.forEachIndexed { index, element ->
            Log.d("MainActivity","list["+index+"]="+element)
        }

        val mutableList: MutableList<Int>
        mutableList = mutableListOf(1, 2 ,3)
        Log.d("MainActivity","2番目"+mutableList.get(1)+":"+mutableList[1])

        var list: MutableList<MutableList<String>> = mutableListOf()

        var list1 = mutableListOf("abc", "def", "ghi")
        var list2 = mutableListOf("jkl", "opq", "rstu")
        var list3 = mutableListOf("vwx", "yz!", "!#$")

        list.add(list1)
        list.add(list2)
        list.add(list3)

        list.forEachIndexed { index, element ->
            element.forEachIndexed { index2, element2 ->
                Log.d("MainActivity","list["+index+"]["+index2+"]="+element2)
            }
        }


    }

    override fun onClick(p0: View?) {
        when (p0!!.id) {
            R.id.button -> buttonClick()
            else -> imagebuttonClick(p0)
        }
    }

    fun imagebuttonClick(p0: View?){
        if(isFinal){                                //試合終了なら処理しない
            return
        }
        var button = p0 as ImageButton
        var array  = button.getTag() as Array<Int>
        textView3.text = ""
        if(squares.isKUHAKU(array[0],array[1])){
            squares.click(array[0], array[1], next)
            var win = squares.jug(numberPicker2.value,numberPicker.value)                 //終了判定処理呼び出し
            if(win != Const.KUHAKU){                //試合終了なら終了処理呼び出し
                final(win)
            }
            next = !next
        }else {
            textView3.text = getString(R.string.MSG_ALREADY)
        }
    }

    fun init(){
        squares.allClear()
        next = true;
        buttonSet()
    }

    fun buttonClick(){
        if(isFinal){    //START
            init()
            textView3.text=getString(R.string.MSG_PROMPT)
            isFinal = false
            setBan()
            buttonSet()
        }else{          //RESET
            createDialog()
        }
    }

    fun final(win:Int){
        textView3.text = resources.getStringArray(R.array.MSG_FINAL)[win]
        isFinal = true
        buttonSet()
    }

    fun buttonSet(){
        if(isFinal){
            button.text = getString(R.string.LABEL_START)
            button.setBackgroundResource(R.drawable.button_blue)
        }else{
            button.text = getString(R.string.LABEL_RESET)
            button.setBackgroundResource(R.drawable.button_red)

        }
    }

    fun createDialog(){
        AlertDialog.Builder(this)
            .setTitle("RESET?")
            .setMessage(getString(R.string.MSG_RESET_CONFIRT))
            .setPositiveButton(getString(R.string.LABEL_OK)) { dialog, which -> //OK選択時処理
                init()
                isFinal = true
                buttonSet()
            }
            .setNegativeButton(getString(R.string.LABEL_NO), { dialog, which ->//NO選択時処理（何もしない）
            })
            .show()
    }
    fun setBan(){
        for(idx1 in imagebutton.indices) {
            if(idx1 < numberPicker2.value){
                row[idx1].setVisibility(View.VISIBLE);
            }else{
                row[idx1].setVisibility(View.GONE);
            }

            for (idx2 in imagebutton[idx1].indices) {
                if(idx2 < numberPicker2.value){
                    imagebutton[idx1][idx2].setVisibility(View.VISIBLE);
                }else{
                    imagebutton[idx1][idx2].setVisibility(View.GONE);
                }
            }
        }
    }
    override fun onValueChange(p0: NumberPicker?, p1: Int, p2: Int) {
        if(p0!!.id == R.id.numberPicker){
            numberPicker2.minValue =  numberPicker.value
            numberPicker2.value =  numberPicker.value
        }
    }
}



